#property copyright ""
#property link ""
#property strict

#define RETRY_COUNT 3

#include <Tkool\Tkool.mqh>
enum timeframe {
   CURRENT = 0, // チャートの時間足
   M1      = 1,
   M5      = 5,
   M15     = 15,
   M30     = 30,
   H1      = 60,
   H4      = 240,
   D1      = 1440,
   W1      = 10080,
   MN1     = 43200,
// ---MT5専用時間足--- //
   M2      = 2,
   M3      = 3,
   M4      = 4,
   M6      = 6,
   M10     = 10,
   M12     = 12,
   M20     = 20,
   H2      = 16386,
   H3      = 16387,
   H6      = 16390,
   H8      = 16392,
   H12     = 16396,
};


input int Magic1 = 1;
input int Magic2 = 2;
input int Magic3 = 3;
input int Magic4 = 4;

input double Lots       = 0.01;
input double StopLoss   = 0.0;
input double TakeProfit = 20;
input int    Slippage   = 10;
input string comment    = "";

input bool isTimeFilter = true;
input string TimeFilterStartTime1 = "03:00";
input string TimeFilterEndTime1 = "14:00";
input bool isNanpin = true;
input int NanpinCount = 29;
input double NanpinInterval = 10;
input double NanpinMult = 1.24;
input double NanpinTP = 20;
input double NanpinSL = 9999999999;
input double NanpinAdd = 0;
input int NanpinCustom = 0;
input string NanpinLots = "";
input double NanpinMax = 0;
input double Number_value_1_2_2 = 1000; //初期ナンピン決済金額L
input double Number_value_1_3_2 = 30000; //Number_value
input double Number_value_2_2_2 = 1000; //初期ナンピン決済金額S
input double Number_value_2_3_2 = 30000; //Number_value
input double Number_value_3_1_2 = -200000; //最終ポジエントリー金額L
input double Number_value_3_2_2 = 30000; //最終ポジ決済金額L
input double Number_value_4_1_2 = -200000; //最終ポジエントリー金額S
input double Number_value_4_2_2 = 30000; //最終ポジ決済金額S

bool Trade = true;
datetime lastAlertTime;
color ArrowColor[2] = {clrBlue, clrRed};
int magic_array[4];
int bars1;
int bars2;
int bars3;
int bars4;

//--------------------------------------------------------------------------------------------------------+
//初期化処理
//--------------------------------------------------------------------------------------------------------+
int OnInit()
{
   int count = Bars(_Symbol, _Period);   
   ArraySetAsSeries(Time, true);
   CopyTime(_Symbol, _Period, 0, count, Time);

   if(IsTradeAllowed() == false) {
      Alert("Enable the setting 'Allow live trading' in the Expert Properties!");
   }

   magic_array[0] = Magic1;
   magic_array[1] = Magic2;
   magic_array[2] = Magic3;
   magic_array[3] = Magic4;
   bars1 = getBars(Magic1);
   bars2 = getBars(Magic2);
   bars3 = getBars(Magic3);
   bars4 = getBars(Magic4);

   return(INIT_SUCCEEDED);
}

//--------------------------------------------------------------------------------------------------------+
//メイン処理
//--------------------------------------------------------------------------------------------------------+
void OnTick()
{
   initializeMQL4PredefinedVariables();
   int signal = 0;
   double lots = Lots;
   double take_profit = TakeProfit;
   double stop_loss = StopLoss;
   Trade = true;

   if(isNanpin == true) NanpinLogic(NanpinCount, NanpinCustom, NanpinLots, NanpinInterval, NanpinMult, NanpinTP, NanpinSL, NanpinAdd, NanpinMax, magic_array);


   if(Trade == false) return;
   lots = Lots;
   take_profit = TakeProfit;
   stop_loss = StopLoss;
   signal = 0;
   if(iClose(Symbol(), PERIOD_M1, 1)+PipsToPrice(0)  <  iClose(Symbol(), PERIOD_M1, 0)+PipsToPrice(0)) signal = 1;
   if(isTimeFilter == true && TimeFilter(signal, TimeFilterStartTime1, TimeFilterEndTime1) == false) signal = 0;


   if(signal != 0 && getOpenLots(Magic1) == 0) {

      if(openPosition(signal, lots, take_profit, stop_loss, Magic1)) {
         bars1 = Bars(_Symbol, _Period);
      }
   }
   lots = Lots;
   take_profit = TakeProfit;
   stop_loss = StopLoss;
   signal = 0;
   if(getOrderProfit("1",1,false) + (0)  >  Number_value_1_2_2) signal = 1;
   if(signal != 0 && getOpenLots(Magic1, OP_BUY) != 0) {
      closePosition(Magic1, OP_BUY);
   }
   lots = Lots;
   take_profit = TakeProfit;
   stop_loss = StopLoss;
   signal = 0;
   if(getOrderProfit("1,3",1,false) + (0)  >  Number_value_1_3_2) signal = 1;
   if(signal != 0 && getOpenLots(Magic1, OP_BUY) != 0) {
      closePosition(Magic1, OP_BUY);
   }
   lots = Lots;
   take_profit = TakeProfit;
   stop_loss = StopLoss;
   signal = 0;
   if(iClose(Symbol(), PERIOD_M1, 1)+PipsToPrice(0)  >  iClose(Symbol(), PERIOD_M1, 0)+PipsToPrice(0)) signal = -1;
   if(isTimeFilter == true && TimeFilter(signal, TimeFilterStartTime1, TimeFilterEndTime1) == false) signal = 0;


   if(signal != 0 && getOpenLots(Magic2) == 0) {

      if(openPosition(signal, lots, take_profit, stop_loss, Magic2)) {
         bars2 = Bars(_Symbol, _Period);
      }
   }
   lots = Lots;
   take_profit = TakeProfit;
   stop_loss = StopLoss;
   signal = 0;
   if(getOrderProfit("2",2,false) + (0)  >  Number_value_2_2_2) signal = -1;
   if(signal != 0 && getOpenLots(Magic2, OP_SELL) != 0) {
      closePosition(Magic2, OP_SELL);
   }
   lots = Lots;
   take_profit = TakeProfit;
   stop_loss = StopLoss;
   signal = 0;
   if(getOrderProfit("2,4",2,false) + (0)  >  Number_value_2_3_2) signal = -1;
   if(signal != 0 && getOpenLots(Magic2, OP_SELL) != 0) {
      closePosition(Magic2, OP_SELL);
   }
   lots = Lots;
   take_profit = TakeProfit;
   stop_loss = StopLoss;
   signal = 0;
   if(getOrderProfit("1",1,false) + (0)  <  Number_value_3_1_2
    && iMA(Symbol(), PERIOD_M5, 10, 0, MODE_EMA, PRICE_CLOSE, 2)+PipsToPrice(0)  <  iMA(Symbol(), PERIOD_M5, 40, 0, MODE_EMA, PRICE_CLOSE, 2)+PipsToPrice(0)
    && iMA(Symbol(), PERIOD_M5, 10, 0, MODE_EMA, PRICE_CLOSE, 1)+PipsToPrice(0)  >  iMA(Symbol(), PERIOD_M15, 40, 0, MODE_EMA, PRICE_CLOSE, 1)+PipsToPrice(0)
    && iClose(Symbol(), PERIOD_M5, 0)+PipsToPrice(0)  >  iMA(Symbol(), PERIOD_M5, 20, 0, MODE_EMA, PRICE_CLOSE, 0)+PipsToPrice(0)) signal = 1;
   if(isTimeFilter == true && TimeFilter(signal, TimeFilterStartTime1, TimeFilterEndTime1) == false) signal = 0;


   if(signal != 0 && getOpenLots(Magic3) == 0) {
      lots = 5;
      take_profit = 1000;
      stop_loss = 50;

      if(openPosition(signal, lots, take_profit, stop_loss, Magic3)) {
         bars3 = Bars(_Symbol, _Period);
      }
   }
   lots = Lots;
   take_profit = TakeProfit;
   stop_loss = StopLoss;
   signal = 0;
   if(getOrderProfit("1,3",1,false) + (0)  >  Number_value_3_2_2) signal = 1;
   if(signal != 0 && getOpenLots(Magic3, OP_BUY) != 0) {
      closePosition(Magic3, OP_BUY);
   }
   lots = Lots;
   take_profit = TakeProfit;
   stop_loss = StopLoss;
   signal = 0;
   if(getOrderProfit("2",2,false) + (0)  <  Number_value_4_1_2
    && iMA(Symbol(), PERIOD_M5, 10, 0, MODE_EMA, PRICE_CLOSE, 2)+PipsToPrice(0)  >  iMA(Symbol(), PERIOD_M5, 40, 0, MODE_EMA, PRICE_CLOSE, 2)+PipsToPrice(0)
    && iMA(Symbol(), PERIOD_M5, 10, 0, MODE_EMA, PRICE_CLOSE, 1)+PipsToPrice(0)  <  iMA(Symbol(), PERIOD_M15, 40, 0, MODE_EMA, PRICE_CLOSE, 1)+PipsToPrice(0)
    && iClose(Symbol(), PERIOD_M5, 0)+PipsToPrice(0)  <  iMA(Symbol(), PERIOD_M5, 20, 0, MODE_EMA, PRICE_CLOSE, 0)+PipsToPrice(0)) signal = -1;
   if(isTimeFilter == true && TimeFilter(signal, TimeFilterStartTime1, TimeFilterEndTime1) == false) signal = 0;


   if(signal != 0 && getOpenLots(Magic4) == 0) {
      lots = 5;
      take_profit = 1000;
      stop_loss = 50;

      if(openPosition(signal, lots, take_profit, stop_loss, Magic4)) {
         bars4 = Bars(_Symbol, _Period);
      }
   }
   lots = Lots;
   take_profit = TakeProfit;
   stop_loss = StopLoss;
   signal = 0;
   if(getOrderProfit("2,4",2,false) + (0)  >  Number_value_4_2_2) signal = -1;
   if(signal != 0 && getOpenLots(Magic4, OP_SELL) != 0) {
      closePosition(Magic4, OP_SELL);
   }

}

//--------------------------------------------------------------------------------------------------------+
//|ロット数取得関数
//|   処理:引数に指定した単数ポジションのロット数を取得
//|   引数:ロット数を取得するポジションのマジックナンバー,売買種別
//|   戻り値:ポジションのロット数
//--------------------------------------------------------------------------------------------------------+
double getOpenLots(int magic, int type = -1)
{
   double lots = 0;

   for(int i = OrdersTotal() - 1; i >= 0; i--) {
      if(OrderSelect(i, SELECT_BY_POS) == false) return(-1);
      if(OrderSymbol() != Symbol() || OrderMagicNumber() != magic) continue;

      if(type == -1 || OrderType() == type) lots += OrderLots();
   }

   return(lots);
}

//--------------------------------------------------------------------------------------------------------+
//|ロット数取得関数
//|   処理:引数に指定した複数ポジションのロット数を取得
//|   引数:ロット数を取得するポジションのマジックナンバー（,区切りで指定）,売買種別
//|   戻り値:指定したポジションのロット数
//--------------------------------------------------------------------------------------------------------+
double getOpenMultipleLots(string magicstring, int type = -1)
{
   double lots = 0;
   string magics[];
   int    sep_num;
   
   sep_num = StringSplit(magicstring , ',' , magics);

   if(sep_num>0){
      for(int i = OrdersTotal() - 1; i >= 0; i--) {
         if(OrderSelect(i, SELECT_BY_POS) == false) return(-1);
         if(OrderSymbol() != Symbol() || !checkMagicNumbers(magics,OrderMagicNumber())) continue;

         if(type == -1 || OrderType() == type) lots += OrderLots();
      }
   }

   return(lots);
}

//--------------------------------------------------------------------------------------------------------+
//|ロット数調整用関数
//|   処理:ロット数が最大値・最小値の範囲から外れていれば最大値・最小値にし、ステップ幅に応じて小数点以下を丸め、変更後のロット数を返す
//|   引数:ロット数
//|   戻り値:調整されたロット数
//--------------------------------------------------------------------------------------------------------+
double checkLots(double lots)
{
   double min_lots = MarketInfo(Symbol(), MODE_MINLOT);
   double max_lots = MarketInfo(Symbol(), MODE_MAXLOT);
   double step     = MarketInfo(Symbol(), MODE_LOTSTEP);

   if(lots < min_lots) lots = min_lots;
   if(lots > max_lots) lots = max_lots;

   if(step == 1) {
      lots = NormalizeDouble(lots, 0);
   }
   else if(step == 0.1) {
      lots = NormalizeDouble(lots, 1);
   }
   else {
      lots = NormalizeDouble(lots, 2);
   }

   return(lots);
}

//--------------------------------------------------------------------------------------------------------+
//|エントリー注文送信用関数
//|   処理:エントリー注文に必要な数値が正しいかを確認し、エントリー注文を送信する。
//|   引数:売買種別(買い:正の整数, 売り:負の整数),ロット数,テイクプロフィット,ストップロス,ポジションのマジックナンバー
//|   戻り値:処理結果(true:注文成功, false:注文失敗)
//--------------------------------------------------------------------------------------------------------+
bool openPosition(int signal, double lots, double tp_pips, double sl_pips, int magic)
{
   int    type = 0;
   long   ticket = 0;
   double price = 0, sl = 0, tp = 0;

   lots = checkLots(lots);

   switch(signal) {
      case 1:
         type = OP_BUY;
         price = Ask;
         if(tp_pips > 0) tp = Ask + PipsToPrice(tp_pips);
         if(sl_pips > 0) sl = Ask - PipsToPrice(sl_pips);
         break;
      case -1:
         type = OP_SELL;
         price = Bid;
         if(tp_pips > 0) tp = Bid - PipsToPrice(tp_pips);
         if(sl_pips > 0) sl = Bid + PipsToPrice(sl_pips);
         break;
      default:
         return(false);
         break;
   }

   if(marginCheck(type, lots, price) == false) return(false);
   for(int i = 0; i < RETRY_COUNT; i++) {
      if(IsTradeAllowed() == true) {
         RefreshRates();
         ticket = OrderSend(Symbol(), type, lots, price, Slippage, sl, tp, comment, magic, 0, ArrowColor[type]);

         int err = GetLastError();
         if(ticket > 0) return(true);
         if(err > 0){
            Print("[OrderSend Error] : ", err, " ", ErrorDescription(err));
         }
         if(IsTesting() == true) break;
      }

      if(i + 1 == RETRY_COUNT && ticket == -1) {
         Alert("[OrderSend Error] : Order timeout. Check the experts log.");
         return(false);
      }

      Sleep(200);
   }

   return(false);
}


//--------------------------------------------------------------------------------------------------------+
//|ポジション情報(テイクプロフィット,ストップロス)変更用関数
//|   処理:オープンポジションのテイクプロフィット、ストップロスの変更注文を送信する。
//|   引数:テイクプロフィット,ストップロス,変更するポジションのマジックナンバー
//|   戻り値:処理結果(true:注文成功, false:注文失敗)
//--------------------------------------------------------------------------------------------------------+
bool setTPSL(double tp, double sl, long ticket)
{
   if(OrderSelect(ticket, SELECT_BY_TICKET) == false) return(false);

   if(tp == 0) tp = OrderTakeProfit();
   if(sl == 0) sl = OrderStopLoss();

   if(MathAbs(tp - OrderTakeProfit()) < 0.0000001 && MathAbs(sl - OrderStopLoss()) < 0.0000001) return(false);

   for(int i = 0; i < RETRY_COUNT; i++) {
      if(IsTradeAllowed() == true) {
         if(OrderModify(ticket, OrderOpenPrice(), sl, tp, 0, clrNONE) == true) return(true);

         int err = GetLastError();
         Print("[OrderModify Error] : ", err, " ", ErrorDescription(err));
         if(IsTesting() == true) break;
      }

      if(i + 1 == RETRY_COUNT && ticket == -1) {
         Alert("[OrderModify Error] : Order timeout. Check the experts log.");
         return(false);
      }

      Sleep(200);
   }

   return(false);
}

//--------------------------------------------------------------------------------------------------------+
//ポジション決済用関数
//   処理:決済注文に必要な数値が正しいかを確認し決済注文を送信する。
//   引数:決済するポジションのマジックナンバー,売買種別
//   戻り値:処理結果(true:決済成功, false:決済失敗)
//--------------------------------------------------------------------------------------------------------+
bool closePosition(int magic, int type = -1)
{
   int result_count = 0;
   int close_signal = 0;

   if(IsTradeAllowed() == true) {
      for(int i = OrdersTotal() - 1; i >= 0; i--) {
         if(OrderSelect(i, SELECT_BY_POS) == false) continue;
         if(OrderSymbol() != Symbol() || OrderMagicNumber() != magic) continue;
         if(type >= 0 && OrderType() != type) continue;
         RefreshRates();

         if(OrderClose(OrderTicket(), OrderLots(), OrderClosePrice(), Slippage, ArrowColor[OrderType()]) == true) {
            
            continue;
         }else{
            result_count = 0;
            for(int j = 0; j < RETRY_COUNT; j++) {
               Sleep(200);

               if(OrderClose(OrderTicket(), OrderLots(), OrderClosePrice(), Slippage, ArrowColor[OrderType()]) == true) {
                  break;
               }else{
                  int err = GetLastError();
                  if(err > 0){
                     result_count++;
                     Print("[OrderClose Error] : ", err, " ", ErrorDescription(err));
                  }
               }
               if(result_count == RETRY_COUNT) {
                  close_signal++;
               }
            }
         }
      }
      if(close_signal == 0) return(true);
      Alert("[OrderClose Error] : Close timeout. Check the experts log.");      
   }
   return(false);
}

//--------------------------------------------------------------------------------------------------------+
//価格換算用関数
//   処理:pipsを価格に換算する。
//   引数:換算する値
//   戻り値:調整された価格
//--------------------------------------------------------------------------------------------------------+
double PipsToPrice(double value)
{
   int mult = (_Digits == 3 || _Digits == 5) ? 10 : 1;
   return(value * _Point * mult);
}

//--------------------------------------------------------------------------------------------------------+
//価格換算用関数
//   処理:価格の小数点値に換算する。
//   引数:換算する値
//   戻り値:調整された価格
//--------------------------------------------------------------------------------------------------------+
double PointToPrice(int value)
{
   return(value * _Point);
}

//--------------------------------------------------------------------------------------------------------+
//pips換算用関数
//   処理:価格をpipsに換算する。
//   引数:換算する値
//   戻り値:調整されたpips
//--------------------------------------------------------------------------------------------------------+
double PriceToPips(double value)
{
   int mult = (_Digits == 3 || _Digits == 5) ? 10 : 1;
   return(value / _Point/ mult);
}

//--------------------------------------------------------------------------------------------------------+
//pips換算用関数
//   処理:指定した通貨ペアの小数点以下桁数をもとに価格をpipsに換算する。
//   引数:換算する値,換算する通貨ペア
//   戻り値:調整されたpips
//--------------------------------------------------------------------------------------------------------+
double PriceToPipsWithSymbol(double value, string symbol)
{
   double Symbol_Digits = MarketInfo(symbol,MODE_DIGITS);
   int mult = (Symbol_Digits == 3 || Symbol_Digits == 5) ? 10 : 1;
   return(value / MarketInfo(symbol,MODE_POINT) / mult);
}

//--------------------------------------------------------------------------------------------------------+
//損益取得関数
//   処理:ポジションの損益を取得。
//   引数:損益を取得するポジションのマジックナンバー（,区切りで指定）,売買種別(0:すべて,1:買いのみ,2:売りのみ),is_all値(true:すべてのポジション,false:引数に指定したポジション)
//   戻り値:価格で計算したポジションの損益                                                                              
//--------------------------------------------------------------------------------------------------------+
double getOrderProfit(string magicstring, int method, bool is_all)
{
   double profit = 0;
   string magics[];
   int    sep_num;

   sep_num = StringSplit(magicstring , ',' , magics);

   if(sep_num>0) {
      for(int i = OrdersTotal() - 1; i >= 0; i--) {
         if(OrderSelect(i, SELECT_BY_POS) == false) continue;
         if(is_all == false && !checkMagicNumbers(magics,OrderMagicNumber())) continue;
         if(method == 0){
            if(OrderType() == OP_BUY || OrderType() == OP_SELL) {
               profit += OrderProfit();
            }
         }else{
            if(method == 1 && OrderType() == OP_BUY) {
               profit += OrderProfit();
            }
            if(method == 2 && OrderType() == OP_SELL) {
               profit += OrderProfit();
            }
         }
      }
   }

   return(profit);
}

//--------------------------------------------------------------------------------------------------------+
//損益取得関数
//   処理:引数に指定した複数ポジションのロット数を取得
//   引数:損益を取得するポジションのマジックナンバー（,区切りで指定）,売買種別(0:すべて,1:買いのみ,2:売りのみ),is_all値(true:すべてのポジション,false:引数に指定したポジション)
//   戻り値:pipsで計算したポジションの損益
//--------------------------------------------------------------------------------------------------------+
double getOrderProfitPips(string magicstring, int method, bool is_all)
{
   double profit = 0;
   string magics[];
   int    sep_num;

   sep_num = StringSplit(magicstring , ',' , magics);

   if(sep_num>0) {
      for(int i = OrdersTotal() - 1; i >= 0; i--) {
         if(OrderSelect(i, SELECT_BY_POS) == false) continue;
         if(is_all == false && !checkMagicNumbers(magics,OrderMagicNumber())) continue;
         if(method == 0){
            if(OrderType() == OP_BUY) {
               profit += PriceToPipsWithSymbol(MarketInfo(OrderSymbol(),MODE_BID) - OrderOpenPrice(),OrderSymbol());
            }
            if(OrderType() == OP_SELL) {
               profit += PriceToPipsWithSymbol(OrderOpenPrice() - MarketInfo(OrderSymbol(),MODE_ASK),OrderSymbol());
            }
         }else{
            if(method == 1 && OrderType() == OP_BUY) {
               profit += PriceToPipsWithSymbol(MarketInfo(OrderSymbol(),MODE_BID) - OrderOpenPrice(),OrderSymbol());
            }
            if(method == 2 && OrderType() == OP_SELL) {
               profit += PriceToPipsWithSymbol(OrderOpenPrice() - MarketInfo(OrderSymbol(),MODE_ASK),OrderSymbol());
            }
         }
      }
   }

   return(profit);
}

//--------------------------------------------------------------------------------------------------------+
//マジックナンバー比較用関数
//   処理:入力したマジックナンバーと保有中ポジションのマジックナンバーを複数調べる関数
//   引数:確認するポジションのマジックナンバー（配列）,比較するマジックナンバー
//   戻り値:処理結果(true:一致, false:不一致)
//--------------------------------------------------------------------------------------------------------+
bool checkMagicNumbers(string& magics[], int OrderMagic)
{
   for(int i = ArraySize(magics) - 1; i >= 0; i--) {
      if(OrderMagic == magic_array[StrToInteger(magics[i])-1]) return (true);
   }
   return (false);
}

//--------------------------------------------------------------------------------------------------------+
//最終エントリーしたバー数取得処理
//   処理:最終エントリーしたバー数を取得する処理
//   引数:マジックナンバー
//   戻り値:最終エントリーしたバー数
//--------------------------------------------------------------------------------------------------------+
int getBars(int magic)
{
   datetime open_time = 0, close_time = 0, time;
   int bars = Bars(_Symbol, _Period), i;

   for(i = OrdersTotal() - 1; i >= 0; i--) {
      if(OrderSelect(i, SELECT_BY_POS) == false) continue;
      if(OrderMagicNumber() != magic || OrderSymbol() != Symbol()) continue;

      if(open_time < OrderOpenTime()) {
         open_time = OrderOpenTime();
      }
   }

   for(i = OrdersHistoryTotal() - 1; i >= 0; i--) {
      if(OrderSelect(i, SELECT_BY_POS, MODE_HISTORY) == false) continue;
      if(OrderMagicNumber() != magic || OrderSymbol() != Symbol()) continue;

      if(close_time < OrderOpenTime()) {
         close_time = OrderOpenTime();
      }
   }

   if(close_time == 0 && open_time == 0) return(0);

   time = (close_time > open_time) ? close_time : open_time;

   for(i = 0; i < Bars(_Symbol, _Period); i++) {
      if(time < Time[i]) {
         bars = Bars(_Symbol, _Period) - i;
      }
      else {
         break;
      }
   }

   return(bars);
}

//--------------------------------------------------------------------------------------------------------+
//ポジション数取得関数
//   処理:引数に指定したマジックナンバー（単一）のポジション数を取得。
//   引数:ポジションのマジックナンバー,売買種別
//   戻り値:ポジションの合計数
//--------------------------------------------------------------------------------------------------------+
int getOpenPositions(int magic, int type = -1)
{
   int positions = 0, i;
   
   for(i = OrdersTotal() - 1; i >= 0; i--) {
      if(OrderSelect(i, SELECT_BY_POS) == false) continue;
      if(OrderMagicNumber() != magic) continue;

      if(type == -1 || OrderType() == type) positions++;
   }
   
   return(positions);
}

//--------------------------------------------------------------------------------------------------------+
//ポジション数取得関数
//   処理:引数に指定したマジックナンバー（複数）のポジション数を取得。
//   引数:ポジションのマジックナンバー（,区切りで指定）,売買種別
//   戻り値:ポジションの合計数
//--------------------------------------------------------------------------------------------------------+
int getOpenMultiplePositions(string magicstring, int type = -1)
{
   int positions = 0, i;
   string magics[];
   int    sep_num;
   
   sep_num = StringSplit(magicstring , ',' , magics);

   if(sep_num>0){
      for(i = OrdersTotal() - 1; i >= 0; i--) {
         if(OrderSelect(i, SELECT_BY_POS) == false) continue;
         if(!checkMagicNumbers(magics,OrderMagicNumber())) continue;

         if(type == -1 || OrderType() == type) positions++;
      }
   }

   return(positions);
}

//--------------------------------------------------------------------------------------------------------+
//最終エントリーしたバーシフト数取得処理
//   処理:最終エントリーしたバーシフトを取得する
//   引数:通貨ペア,時間足,マジックナンバー
//   戻り値:最終エントリー時のバーシフト数
//--------------------------------------------------------------------------------------------------------+
int getLastEntryBar(string symbol, int period, int offset, int magic)
{
   int i;
   for(i = OrdersTotal() - 1; i >= 0; i--) {
      if(OrderSelect(i, SELECT_BY_POS) == false) continue;
      if(OrderMagicNumber() != magic) continue;

      if(OrderType() == OP_BUY || OrderType() == OP_SELL) {
         int shift = iBarShift(symbol, period, OrderOpenTime(), false) + offset;
         return(shift);
      }
   }
   for(i = OrdersHistoryTotal() - 1; i >= 0; i--) {
      if(OrderSelect(i, SELECT_BY_POS, MODE_HISTORY) == false) continue;
      if(OrderMagicNumber() != magic) continue;

      if(OrderType() == OP_BUY || OrderType() == OP_SELL) {
         int shift = iBarShift(symbol, period, OrderOpenTime(), false) + offset;
         return(shift);
      }
   }
   return(-1);
}

//--------------------------------------------------------------------------------------------------------+
//指定した時間のバーシフト数取得処理
//   処理:指定した時間のバーシフトを取得する
//   引数:通貨ペア,時間足,バーシフト数を取得する時間
//   戻り値:指定した時間のバーシフト数
//--------------------------------------------------------------------------------------------------------+
int getTimeSelectBar(string symbol, int period, string selectTime)
{
   string currentTime = TimeToStr(TimeCurrent(), TIME_MINUTES);
   string nowDate = TimeToStr(TimeCurrent(), TIME_DATE);
   datetime selectDateTime = StringToTime(nowDate + " " + selectTime);
   int backDayCount = 4;

   if(currentTime <= selectTime) selectDateTime -= 86400; // 指定した時刻が現在時刻より未来の場合、前日の時刻を取得

   for(int i = 0; i < backDayCount; i++) {
      int shift = iBarShift(Symbol(), Period(), selectDateTime, true);
      if(shift != -1) return(shift);
      selectDateTime -= 86400;
   }
   return(-1);
}

//--------------------------------------------------------------------------------------------------------+
//ローソク足の構成要素（ヒゲ）算出処理
//   処理:入力されたローソク足の構成要素を算出する処理
//   引数:通貨ペア,時間足,ローソク足の位置,ローソク足の構成(0:上ヒゲ,1:実体,2:下ヒゲ,3:値幅)
//   戻り値:指定したローソク足の構成から算出したpips
//--------------------------------------------------------------------------------------------------------+
double getCandleStickPips(string symbol, int period, int shift, int hige) 
{
   int digits   = (int)MarketInfo(symbol, MODE_DIGITS);
   double open  = iOpen(symbol,period,shift);
   double close = iClose(symbol,period,shift);
   double high  = iHigh(symbol,period,shift);
   double low   = iLow(symbol,period,shift);
   
   // 陽線の場合
   if (open < close) {
      if (hige == 0) {
         return (NormalizeDouble(PriceToPips(MathAbs(high - close)), digits));
      }
      else if (hige == 1) {
         return (NormalizeDouble(PriceToPips(MathAbs(close - open)), digits));
      }
      else if (hige == 2) {
         return (NormalizeDouble(PriceToPips(MathAbs(open - low)), digits));
      }
      else if (hige == 3) {
         return (NormalizeDouble(PriceToPips(MathAbs(high - low)), digits));
      }
      else {
         return (NormalizeDouble(PriceToPips(MathAbs(high - close)), digits));
      }
   }
   // 陰線の場合
   else {
      if (hige == 0) {
         return (NormalizeDouble(PriceToPips(MathAbs(high - open)), digits));
      }
      else if (hige == 1) {
         return (NormalizeDouble(PriceToPips(MathAbs(open - close)), digits));
      }
      else if (hige == 2) {
         return (NormalizeDouble(PriceToPips(MathAbs(close - low)), digits));
      }
      else if (hige == 3) {
         return (NormalizeDouble(PriceToPips(MathAbs(high - low)), digits));
      }
      else {
         return (NormalizeDouble(PriceToPips(MathAbs(high - open)), digits));
      }
   }
   return 0;
}

//--------------------------------------------------------------------------------------------------------+
//テクニカル指標RCI算出処理
//   処理:RCIを算出する処理
//   引数:通貨ペア,時間足,ローソク足の本数,ローソク足の位置
//   戻り値:RCI
//--------------------------------------------------------------------------------------------------------+
double iRCI(string symbol, int period, int number, int shift)
{
    int rank;
    double d = 0;
    double close_price[];
    ArrayResize(close_price, number); 

    for (int i = 0; i < number; i++) {
        close_price[i] = iClose(symbol, period, i+shift);
    }
    
    ArraySort(close_price, WHOLE_ARRAY, 0, MODE_DESCEND);
    
    for (int i = 0; i < number; i++) {
        rank = ArrayBsearch(close_price,iClose(symbol, period, i+shift),WHOLE_ARRAY,0,MODE_DESCEND);
        d += MathPow(i-rank,2);
    }

    return((1 - 6 * d / (number * (number * number - 1))) * 100);
}

//--------------------------------------------------------------------------------------------------------+
//注文送信時の余剰証拠金確認
//   処理:指定した引数でエントリーした場合の、余剰証拠金を確認する
//   引数:売買種別,ロット数,価格
//   戻り値:処理結果(true:問題なし, false:余剰証拠金不足)
//--------------------------------------------------------------------------------------------------------+
bool marginCheck(int type, double lots, double price)
{  
   if(AccountFreeMarginCheck(Symbol(),type,lots) <= 0) {
      if(lastAlertTime != Time[0]) {
         Alert("[OrderSend Error] : Not enough money");
         lastAlertTime = Time[0]; 
      }
      return(false);
   }
   return(true);
}

//+--------------------------------------------------------------------------------------------------------+
//| 一定期間内の始値または終値の最大値または最小値を取得する関数
//|   処理:指定された期間内の始値または終値の最大値または最小値を取得する
//|   引数:通貨ペア,時間足,モード,期間,シフト,始値または終値のフラグ
//|   戻り値:始値または終値の最大値または最小値
//+--------------------------------------------------------------------------------------------------------+

double GetExtremePrices(string symbol, int tf, int mode, int period, int shift, int openCloseHighLow) {
   double extremePrice = (mode == MODE_HIGH) ? 0 : DBL_MAX;
   for (int i = shift; i < shift + period; i++) {
      double openPrice = iOpen(symbol, tf, i);
      double closePrice = iClose(symbol, tf, i);
      if (openCloseHighLow == 0) { // 始値のみ
         if (mode == MODE_HIGH) {
            extremePrice = MathMax(extremePrice, openPrice);
         } else {
            extremePrice = MathMin(extremePrice, openPrice);
         }
      } else if (openCloseHighLow == 1) { // 終値のみ
         if (mode == MODE_HIGH) {
            extremePrice = MathMax(extremePrice, closePrice);
         } else {
            extremePrice = MathMin(extremePrice, closePrice);
         }
      } else { // 始値と終値
         if (mode == MODE_HIGH) {
            extremePrice = MathMax(extremePrice, MathMax(openPrice, closePrice));
         } else {
            extremePrice = MathMin(extremePrice, MathMin(openPrice, closePrice));
         }
      }
   }
   return extremePrice;
}


//--------------------------------------------------------------------------------------------------------+
//取引時間帯制限フィルター                                                                                
//   処理:現在の時刻が取引可能時間かを調べる。                                                            
//        取引時間外であればエントリーシグナルを解除する。                                                
//   引数:売買シグナル(買い:正の整数, 売り:負の整数),エントリー開始時刻,エントリー終了時刻                                               
//   戻り値:取引時間帯制限フィルター適用後の売買シグナル、取引可能時間外なら0                                              
//--------------------------------------------------------------------------------------------------------+
int TimeFilter(int signal, string start_time, string end_time)
{
  string time = TimeToStr(TimeCurrent(), TIME_DATE);
  datetime t_start = StringToTime(time + " " + start_time);
  datetime t_end = StringToTime(time + " " + end_time);

  if(t_start < t_end) {
    if(TimeCurrent() >= t_start && TimeCurrent() < t_end) {
      return(signal);
    }
    else {
      return(0);
    }
  }
  else {
    if(TimeCurrent() >= t_end && TimeCurrent() < t_start) {
      return(0);
    }
    else {
      return(signal);
    }
  }

  return(0);
}

//--------------------------------------------------------------------------------------------------------+
//ナンピン関数                                                                                            
//   処理:損益（pips単位）に応じてポジションの追加を行う                                                  
//   引数:ナンピンを行うポジションのマジックナンバー                                                      
//   戻り値:なし                                                                                          
//--------------------------------------------------------------------------------------------------------+
void NanpinLogic(
   int max,
   int is_custom,
   string clots,
   double interval,
   double mult,
   double tp,
   double sl,
   double add,
   double limit,
   int &magic[])
{
   double price, total, lots;
   int count, type;
   if(limit == 0) limit = 10000;

   string custom_lots_str[];
   double custom_lots[];
   int clots_cnt = StringSplit(clots, ',', custom_lots_str);

   if(clots_cnt > 0) {
      clots_cnt = MathMin(clots_cnt, max);
      ArrayResize(custom_lots, max);
      for(int i = 0; i < clots_cnt; i++) {
         custom_lots[i] = StringToDouble(custom_lots_str[i]);
      }
      if(clots_cnt < max) {
         for(int i = clots_cnt; i < max; i++) {
            custom_lots[i] = custom_lots[clots_cnt - 1];
         }
      }
   }

   for(int i = 0; i < ArrayRange(magic, 0); i++) {
      getNanpinInfo(magic[i], type, price, count, total, lots);

      if(price > 0) {
         if((total > tp && tp != 0) || (total * -1 > sl && sl != 0)) {
            if(closePosition(magic[i], type) == true) return;
         }
      }

      if(count >= max) return;

      if(type == OP_BUY && Ask <= (price - PipsToPrice(interval))) {
         if(is_custom == 0) {
            if(add == 0){
               openPosition(1, MathMin(lots * MathPow(mult, count + 1), limit), 0, 0, magic[i]);
            }
            if(add > 0){
               if(mult == 0 || mult == 1) {
                  openPosition(1, MathMin(lots + (add * (count + 1)), limit), 0, 0, magic[i]);
               }
               else {
                  openPosition(1, MathMin(lots * MathPow(mult, count + 1) + (add * (count + 1)), limit), 0, 0, magic[i]);
               }
            }
         }
         else {
            openPosition(1, MathMin(custom_lots[count], limit), 0, 0, magic[i]);
         }
      }

      if(type == OP_SELL && Bid >= (price + PipsToPrice(interval))) {
         if(is_custom == 0) {
            if(add == 0){
               openPosition(-1, MathMin(lots * MathPow(mult, count + 1), limit), 0, 0, magic[i]);
            }
            if(add > 0){
               if(mult == 0 || mult == 1) {
                  openPosition(-1, MathMin(lots + (add * (count + 1)), limit), 0, 0, magic[i]);
               }
               else {
                  openPosition(-1, MathMin(lots * MathPow(mult, count + 1) + (add * (count + 1)), limit), 0, 0, magic[i]);
               }
            }
         }
         else {
            openPosition(-1, MathMin(custom_lots[count], limit), 0, 0, magic[i]);
         }
      }
   }
}

//--------------------------------------------------------------------------------------------------------+
//ナンピンの状態を取得する                                                                                
//   処理:ナンピン中のポジション情報を取得する                                                            
//   引数:マジックナンバー、ポジションの種別、最終エントリー時の価格、                                    
//        ナンピン数、合計損益、初期ロット                                                                
//   戻り値:なし                                                                                          
//--------------------------------------------------------------------------------------------------------+
void getNanpinInfo(
   int    magic,
   int    &type,
   double &entry_price,
   int    &count,
   double &total,
   double &lots)
{
   datetime first_time = 0;
   datetime last_time = 0;
   int i = 0;
   type = -1;
   entry_price = 0;
   count = 0;
   total = 0;
   lots = 0;

   for(i = 0; i < OrdersTotal(); i++) {
      if(OrderSelect(i, SELECT_BY_POS) == false) break;
      if(OrderSymbol() != Symbol() || OrderMagicNumber() != magic) continue;

      if(first_time == 0 || OrderOpenTime() < first_time) {
         type = OrderType();
         entry_price = OrderOpenPrice();
         first_time = OrderOpenTime();
         lots = OrderLots();
      }
   }

   if(first_time == 0) return;

   for(i = 0; i < OrdersTotal(); i++) {
      if(OrderSelect(i, SELECT_BY_POS) == false) break;
      if(OrderSymbol() != Symbol() || OrderMagicNumber() != magic) continue;
      if(OrderType() != type) continue;

      if(OrderOpenTime() > first_time) {
         if(OrderOpenPrice() < entry_price && OrderType() == OP_BUY) {
            entry_price = OrderOpenPrice();
         }
         if(OrderOpenPrice() > entry_price && OrderType() == OP_SELL) {
            entry_price = OrderOpenPrice();
         }
         count++;
      }

      if(OrderType() == OP_BUY) {
         total += PriceToPips(Bid - OrderOpenPrice());
      }
      if(OrderType() == OP_SELL) {
         total += PriceToPips(OrderOpenPrice() - Ask);
      }
   }
}

