#property copyright ""
#property link ""
#property strict

#define RETRY_COUNT 3

#include <Tkool\Tkool.mqh>

enum timeframe {
   CURRENT = 0, // チャートの時間足
   M1      = 1,
   M5      = 5,
   M15     = 15,
   M30     = 30,
   H1      = 60,
   H4      = 240,
   D1      = 1440,
   W1      = 10080,
   MN1     = 43200
};

input int Magic1 = 1;
input int Magic2 = 2;

input double Lots       = 0.01;
input double StopLoss   = 10;
input double TakeProfit = 0;
input int    Slippage   = 9;
input string comment    = "";

input bool isTrailingStop = false;
input double TrailinStopNormalValue = 70;
input bool isSpreadFilter = true;
input double SpreadFilterValue = 3.5;
input bool isPositionFilter = true;
input int MaxPositionValue = 2;



input double Number_value_1_2_2 = 20000; //Number_value




input double Number_value_2_2_2 = 20000; //Number_value


bool Trade = true;
datetime lastAlertTime;
color ArrowColor[2] = {clrBlue, clrRed};
int magic_array[2];
int bars1;
int bars2;

//--------------------------------------------------------------------------------------------------------+
//初期化処理
//--------------------------------------------------------------------------------------------------------+
int OnInit()
{
   int count = Bars(_Symbol, _Period);   
   ArraySetAsSeries(Time, true);
   CopyTime(_Symbol, _Period, 0, count, Time);

   if(IsTradeAllowed() == false) {
      Alert("Enable the setting 'Allow live trading' in the Expert Properties!");
   }

   magic_array[0] = Magic1;
   magic_array[1] = Magic2;
   bars1 = getBars(Magic1);
   bars2 = getBars(Magic2);

   return(INIT_SUCCEEDED);
}

//--------------------------------------------------------------------------------------------------------+
//メイン処理
//--------------------------------------------------------------------------------------------------------+
void OnTick()
{
   initializeMQL4PredefinedVariables();
   int signal = 0;
   double lots = Lots;
   Trade = true;

   if(isTrailingStop == true) TrailingStop(TrailinStopNormalValue, Magic1);
   if(isTrailingStop == true) TrailingStop(TrailinStopNormalValue, Magic2);
   


   if(Trade == false) return;
   signal = 0;
   if(iOpen(Symbol(), 0, 0)+PipsToPrice(0)  >  0) signal = 1;
   if(isSpreadFilter) signal = checkSpread(signal, SpreadFilterValue);
   if(isPositionFilter == true) signal = PositionFilter(MaxPositionValue, magic_array, signal);


   if(signal != 0 && getOpenLots(Magic1) == 0) {

      if(openPosition(signal, lots, TakeProfit, StopLoss, Magic1)) {
         bars1 = Bars;
      }
   }
   signal = 0;
   if(getOrderProfit("0", 0, true)  >  Number_value_1_2_2) signal = 1;
   if(signal != 0 && getOpenLots(Magic1, OP_BUY) != 0) {
      closePosition(Magic1);
   }
   signal = 0;
   if(iOpen(Symbol(), 0, 0)+PipsToPrice(0)  >  0) signal = -1;
   if(isSpreadFilter) signal = checkSpread(signal, SpreadFilterValue);
   if(isPositionFilter == true) signal = PositionFilter(MaxPositionValue, magic_array, signal);


   if(signal != 0 && getOpenLots(Magic2) == 0) {

      if(openPosition(signal, lots, TakeProfit, StopLoss, Magic2)) {
         bars2 = Bars;
      }
   }
   signal = 0;
   if(getOrderProfit("0", 0, true)  >  Number_value_2_2_2) signal = -1;
   if(signal != 0 && getOpenLots(Magic2, OP_SELL) != 0) {
      closePosition(Magic2);
   }

}

//--------------------------------------------------------------------------------------------------------+
//|ロット数取得関数
//|   処理:引数に指定した単数ポジションのロット数を取得
//|   引数:ロット数を取得するポジションのマジックナンバー,売買種別
//|   戻り値:ポジションのロット数
//--------------------------------------------------------------------------------------------------------+
double getOpenLots(int magic, int type = -1)
{
   double lots = 0;

   for(int i = OrdersTotal() - 1; i >= 0; i--) {
      if(OrderSelect(i, SELECT_BY_POS) == false) return(-1);
      if(OrderSymbol() != Symbol() || OrderMagicNumber() != magic) continue;

      if(type == -1 || OrderType() == type) lots += OrderLots();
   }

   return(lots);
}

//--------------------------------------------------------------------------------------------------------+
//|ロット数取得関数
//|   処理:引数に指定した複数ポジションのロット数を取得
//|   引数:ロット数を取得するポジションのマジックナンバー（,区切りで指定）,売買種別
//|   戻り値:指定したポジションのロット数
//--------------------------------------------------------------------------------------------------------+
double getOpenMultipleLots(string magicstring, int type = -1)
{
   double lots = 0;
   string magics[];
   int    sep_num;
   
   sep_num = StringSplit(magicstring , ',' , magics);

   if(sep_num>0){
      for(int i = OrdersTotal() - 1; i >= 0; i--) {
         if(OrderSelect(i, SELECT_BY_POS) == false) return(-1);
         if(OrderSymbol() != Symbol() || !checkMagicNumbers(magics,OrderMagicNumber())) continue;

         if(type == -1 || OrderType() == type) lots += OrderLots();
      }
   }

   return(lots);
}

//--------------------------------------------------------------------------------------------------------+
//|ロット数調整用関数
//|   処理:ロット数が最大値・最小値の範囲から外れていれば最大値・最小値にし、ステップ幅に応じて小数点以下を丸め、変更後のロット数を返す
//|   引数:ロット数
//|   戻り値:調整されたロット数
//--------------------------------------------------------------------------------------------------------+
double checkLots(double lots)
{
   double min_lots = MarketInfo(Symbol(), MODE_MINLOT);
   double max_lots = MarketInfo(Symbol(), MODE_MAXLOT);
   double step     = MarketInfo(Symbol(), MODE_LOTSTEP);

   if(lots < min_lots) lots = min_lots;
   if(lots > max_lots) lots = max_lots;

   if(step == 1) {
      lots = NormalizeDouble(lots, 0);
   }
   else if(step == 0.1) {
      lots = NormalizeDouble(lots, 1);
   }
   else {
      lots = NormalizeDouble(lots, 2);
   }

   return(lots);
}

//--------------------------------------------------------------------------------------------------------+
//|エントリー注文送信用関数
//|   処理:エントリー注文に必要な数値が正しいかを確認し、エントリー注文を送信する。
//|   引数:売買種別(買い:正の整数, 売り:負の整数),ロット数,テイクプロフィット,ストップロス,ポジションのマジックナンバー
//|   戻り値:処理結果(true:注文成功, false:注文失敗)
//--------------------------------------------------------------------------------------------------------+
bool openPosition(int signal, double lots, double tp_pips, double sl_pips, int magic)
{
   int    type = 0, ticket = 0;
   double price = 0, sl = 0, tp = 0;

   lots = checkLots(lots);

   switch(signal) {
      case 1:
         type = OP_BUY;
         price = Ask;
         if(tp_pips > 0) tp = Ask + PipsToPrice(tp_pips);
         if(sl_pips > 0) sl = Ask - PipsToPrice(sl_pips);
         break;
      case -1:
         type = OP_SELL;
         price = Bid;
         if(tp_pips > 0) tp = Bid - PipsToPrice(tp_pips);
         if(sl_pips > 0) sl = Bid + PipsToPrice(sl_pips);
         break;
      default:
         return(false);
         break;
   }

   if(marginCheck(type, lots, price) == false) return(false);
   for(int i = 0; i < RETRY_COUNT; i++) {
      if(IsTradeAllowed() == true) {
         RefreshRates();
         ticket = OrderSend(Symbol(), type, lots, price, Slippage, sl, tp, comment, magic, 0, ArrowColor[type]);

         int err = GetLastError();
         if(ticket > 0) return(true);
         if(err > 0){
            Print("[OrderSend Error] : ", err, " ", ErrorDescription(err));
         }
         if(IsTesting() == true) break;
      }

      if(i + 1 == RETRY_COUNT && ticket == -1) {
         Alert("[OrderSend Error] : Order timeout. Check the experts log.");
         return(false);
      }

      Sleep(200);
   }

   return(false);
}


//--------------------------------------------------------------------------------------------------------+
//|ポジション情報(テイクプロフィット,ストップロス)変更用関数
//|   処理:オープンポジションのテイクプロフィット、ストップロスの変更注文を送信する。
//|   引数:テイクプロフィット,ストップロス,変更するポジションのマジックナンバー
//|   戻り値:処理結果(true:注文成功, false:注文失敗)
//--------------------------------------------------------------------------------------------------------+
bool setTPSL(double tp, double sl, int ticket)
{
   if(OrderSelect(ticket, SELECT_BY_TICKET) == false) return(false);

   if(tp == 0) tp = OrderTakeProfit();
   if(sl == 0) sl = OrderStopLoss();

   if(marginCheck(OrderType(), OrderLots(), OrderOpenPrice()) == false) return(false);
   for(int i = 0; i < RETRY_COUNT; i++) {
      if(IsTradeAllowed() == true) {
         if(OrderModify(ticket, OrderOpenPrice(), sl, tp, 0, clrNONE) == true) return(true);

         int err = GetLastError();
         Print("[OrderModify Error] : ", err, " ", ErrorDescription(err));
         if(IsTesting() == true) break;
      }

      if(i + 1 == RETRY_COUNT && ticket == -1) {
         Alert("[OrderModify Error] : Order timeout. Check the experts log.");
         return(false);
      }

      Sleep(200);
   }

   return(false);
}

//--------------------------------------------------------------------------------------------------------+
//ポジション決済用関数
//   処理:決済注文に必要な数値が正しいかを確認し決済注文を送信する。
//   引数:決済するポジションのマジックナンバー,売買種別
//   戻り値:処理結果(true:決済成功, false:決済失敗)
//--------------------------------------------------------------------------------------------------------+
bool closePosition(int magic, int type = -1)
{
   int result_count = 0;
   int close_signal = 0;

   if(IsTradeAllowed() == true) {
      for(int i = OrdersTotal() - 1; i >= 0; i--) {
         if(OrderSelect(i, SELECT_BY_POS) == false) continue;
         if(OrderSymbol() != Symbol() || OrderMagicNumber() != magic) continue;
         if(type >= 0 && OrderType() != type) continue;
         RefreshRates();

         if(OrderClose(OrderTicket(), OrderLots(), OrderClosePrice(), Slippage, ArrowColor[OrderType()]) == true) {
            
            continue;
         }else{
            result_count = 0;
            for(int j = 0; j < RETRY_COUNT; j++) {
               Sleep(200);

               if(OrderClose(OrderTicket(), OrderLots(), OrderClosePrice(), Slippage, ArrowColor[OrderType()]) == true) {
                  break;
               }else{
                  int err = GetLastError();
                  if(err > 0){
                     result_count++;
                     Print("[OrderClose Error] : ", err, " ", ErrorDescription(err));
                  }
               }
               if(result_count == RETRY_COUNT) {
                  close_signal++;
               }
            }
         }
      }
      if(close_signal == 0) return(true);
      Alert("[OrderClose Error] : Close timeout. Check the experts log.");      
   }
   return(false);
}

//--------------------------------------------------------------------------------------------------------+
//価格換算用関数
//   処理:pipsを価格に換算する。
//   引数:換算する値
//   戻り値:調整された価格
//--------------------------------------------------------------------------------------------------------+
double PipsToPrice(double value)
{
   int mult = (Digits == 3 || Digits == 5) ? 10 : 1;
   return(value * Point * mult);
}

//--------------------------------------------------------------------------------------------------------+
//価格換算用関数
//   処理:価格の小数点値に換算する。
//   引数:換算する値
//   戻り値:調整された価格
//--------------------------------------------------------------------------------------------------------+
double PointToPrice(int value)
{
   return(value * Point);
}

//--------------------------------------------------------------------------------------------------------+
//pips換算用関数
//   処理:価格をpipsに換算する。
//   引数:換算する値
//   戻り値:調整されたpips
//--------------------------------------------------------------------------------------------------------+
double PriceToPips(double value)
{
   int mult = (Digits == 3 || Digits == 5) ? 10 : 1;
   return(value / Point/ mult);
}

//--------------------------------------------------------------------------------------------------------+
//pips換算用関数
//   処理:指定した通貨ペアの小数点以下桁数をもとに価格をpipsに換算する。
//   引数:換算する値,換算する通貨ペア
//   戻り値:調整されたpips
//--------------------------------------------------------------------------------------------------------+
double PriceToPipsWithSymbol(double value, string symbol)
{
   double Symbol_Digits = MarketInfo(symbol,MODE_DIGITS);
   int mult = (Symbol_Digits == 3 || Symbol_Digits == 5) ? 10 : 1;
   return(value / MarketInfo(symbol,MODE_POINT) / mult);
}

//--------------------------------------------------------------------------------------------------------+
//損益取得関数
//   処理:ポジションの損益を取得。
//   引数:損益を取得するポジションのマジックナンバー
//   戻り値:価格で計算したポジションの損益                                                                              
//--------------------------------------------------------------------------------------------------------+
double getOrderProfit(string magicstring, int method, bool is_all)
{
   double profit = 0;
   string magics[];
   int    sep_num;

   sep_num = StringSplit(magicstring , ',' , magics);

   if(sep_num>0) {
      for(int i = OrdersTotal() - 1; i >= 0; i--) {
         if(OrderSelect(i, SELECT_BY_POS) == false) continue;
         if(is_all == false && !checkMagicNumbers(magics,OrderMagicNumber())) continue;
         if(method == 0){
            if(OrderType() == OP_BUY || OrderType() == OP_SELL) {
               profit += OrderProfit();
            }
         }else{
            if(method == 1 && OrderType() == OP_BUY) {
               profit += OrderProfit();
            }
            if(method == 2 && OrderType() == OP_SELL) {
               profit += OrderProfit();
            }
         }
      }
   }

   return(profit);
}

//--------------------------------------------------------------------------------------------------------+
//損益取得関数
//   処理:引数に指定した複数ポジションのロット数を取得
//   引数:損益を取得するポジションのマジックナンバー（,区切りで指定）,売買種別(0:すべて,1:買いのみ,2:売りのみ),is_all値(true:すべてのポジション,false:引数に指定したポジション),
//   戻り値:pipsで計算したポジションの損益
//--------------------------------------------------------------------------------------------------------+
double getOrderProfitPips(string magicstring, int method, bool is_all)
{
   double profit = 0;
   string magics[];
   int    sep_num;

   sep_num = StringSplit(magicstring , ',' , magics);

   if(sep_num>0) {
      for(int i = OrdersTotal() - 1; i >= 0; i--) {
         if(OrderSelect(i, SELECT_BY_POS) == false) continue;
         if(is_all == false && !checkMagicNumbers(magics,OrderMagicNumber())) continue;
         if(method == 0){
            if(OrderType() == OP_BUY) {
               profit += PriceToPipsWithSymbol(MarketInfo(OrderSymbol(),MODE_BID) - OrderOpenPrice(),OrderSymbol());
            }
            if(OrderType() == OP_SELL) {
               profit += PriceToPipsWithSymbol(OrderOpenPrice() - MarketInfo(OrderSymbol(),MODE_ASK),OrderSymbol());
            }
         }else{
            if(method == 1 && OrderType() == OP_BUY) {
               profit += PriceToPipsWithSymbol(MarketInfo(OrderSymbol(),MODE_BID) - OrderOpenPrice(),OrderSymbol());
            }
            if(method == 2 && OrderType() == OP_SELL) {
               profit += PriceToPipsWithSymbol(OrderOpenPrice() - MarketInfo(OrderSymbol(),MODE_ASK),OrderSymbol());
            }
         }
      }
   }

   return(profit);
}

//--------------------------------------------------------------------------------------------------------+
//マジックナンバー比較用関数
//   処理:入力したマジックナンバーと保有中ポジションのマジックナンバーを複数調べる関数
//   引数:確認するポジションのマジックナンバー（配列）,比較するマジックナンバー
//   戻り値:処理結果(true:一致, false:不一致)
//--------------------------------------------------------------------------------------------------------+
bool checkMagicNumbers(string& magics[], int OrderMagic)
{
   for(int i = ArraySize(magics) - 1; i >= 0; i--) {
      if(OrderMagic == magic_array[StrToInteger(magics[i])-1]) return (true);
   }
   return (false);
}

//--------------------------------------------------------------------------------------------------------+
//最終エントリーしたバー数取得処理
//   処理:最終エントリーしたバー数を取得する処理
//   引数:マジックナンバー
//   戻り値:最終エントリーしたバー数
//--------------------------------------------------------------------------------------------------------+
int getBars(int magic)
{
   datetime open_time = 0, close_time = 0, time;
   int bars = Bars, i;

   for(i = OrdersTotal() - 1; i >= 0; i--) {
      if(OrderSelect(i, SELECT_BY_POS) == false) continue;
      if(OrderMagicNumber() != magic || OrderSymbol() != Symbol()) continue;

      if(open_time < OrderOpenTime()) {
         open_time = OrderOpenTime();
      }
   }

   for(i = OrdersHistoryTotal() - 1; i >= 0; i--) {
      if(OrderSelect(i, SELECT_BY_POS, MODE_HISTORY) == false) continue;
      if(OrderMagicNumber() != magic || OrderSymbol() != Symbol()) continue;

      if(close_time < OrderOpenTime()) {
         close_time = OrderOpenTime();
      }
   }

   if(close_time == 0 && open_time == 0) return(0);

   time = (close_time > open_time) ? close_time : open_time;

   for(i = 0; i < Bars; i++) {
      if(time < Time[i]) {
         bars = Bars - i;
      }
      else {
         break;
      }
   }

   return(bars);
}

//--------------------------------------------------------------------------------------------------------+
//ポジション数取得関数
//   処理:引数に指定したマジックナンバー（単一）のポジション数を取得。
//   引数:ポジションのマジックナンバー,売買種別
//   戻り値:ポジションの合計数
//--------------------------------------------------------------------------------------------------------+
int getOpenPositions(int magic, int type = -1)
{
   int positions = 0, i;
   
   for(i = OrdersTotal() - 1; i >= 0; i--) {
      if(OrderSelect(i, SELECT_BY_POS) == false) continue;
      if(OrderMagicNumber() != magic) continue;

      if(type == -1 || OrderType() == type) positions++;
   }
   
   return(positions);
}

//--------------------------------------------------------------------------------------------------------+
//ポジション数取得関数
//   処理:引数に指定したマジックナンバー（複数）のポジション数を取得。
//   引数:ポジションのマジックナンバー（,区切りで指定）,売買種別
//   戻り値:ポジションの合計数
//--------------------------------------------------------------------------------------------------------+
int getOpenMultiplePositions(string magicstring, int type = -1)
{
   int positions = 0, i;
   string magics[];
   int    sep_num;
   
   sep_num = StringSplit(magicstring , ',' , magics);

   if(sep_num>0){
      for(i = OrdersTotal() - 1; i >= 0; i--) {
         if(OrderSelect(i, SELECT_BY_POS) == false) continue;
         if(!checkMagicNumbers(magics,OrderMagicNumber())) continue;

         if(type == -1 || OrderType() == type) positions++;
      }
   }

   return(positions);
}

//--------------------------------------------------------------------------------------------------------+
//最終エントリーしたバーシフト数取得処理
//   処理:最終エントリーしたバーシフトを取得する
//   引数:通貨ペア,時間足,マジックナンバー
//   戻り値:最終エントリー時のバーシフト数
//--------------------------------------------------------------------------------------------------------+
int getLastEntryBar(string symbol, int period, int magic)
{
   int i;
   for(i = OrdersTotal() - 1; i >= 0; i--) {
      if(OrderSelect(i, SELECT_BY_POS) == false) continue;
      if(OrderMagicNumber() != magic) continue;

      if(OrderType() == OP_BUY || OrderType() == OP_SELL) {
         int shift = iBarShift(symbol, period, OrderOpenTime(), false);
         return(shift);
      }
   }
   for(i = OrdersHistoryTotal() - 1; i >= 0; i--) {
      if(OrderSelect(i, SELECT_BY_POS, MODE_HISTORY) == false) continue;
      if(OrderMagicNumber() != magic) continue;

      if(OrderType() == OP_BUY || OrderType() == OP_SELL) {
         int shift = iBarShift(symbol, period, OrderOpenTime(), false);
         return(shift);
      }
   }
   return(-1);
}

//--------------------------------------------------------------------------------------------------------+
//指定した時間のバーシフト数取得処理
//   処理:指定した時間のバーシフトを取得する
//   引数:通貨ペア,時間足,バーシフト数を取得する時間
//   戻り値:指定した時間のバーシフト数
//--------------------------------------------------------------------------------------------------------+
int getTimeSelectBar(string symbol, int period, string selectTime)
{
   string currentTime = TimeToStr(TimeCurrent(), TIME_MINUTES);
   string nowDate = TimeToStr(TimeCurrent(), TIME_DATE);
   datetime selectDateTime = StringToTime(nowDate + " " + selectTime);
   int backDayCount = 4;

   if(currentTime <= selectTime) {
      for(int i = 0; i < backDayCount; i++) {
         selectDateTime = selectDateTime - 86400;
         int shift = iBarShift(Symbol(), Period(), selectDateTime, true);
         if(shift == -1)continue;
         return(shift);
      }
   }
   for(int i = 0; i < backDayCount; i++) {
      selectDateTime = selectDateTime - 86400;
      int shift = iBarShift(Symbol(), Period(), selectDateTime, true);
      if(shift == -1)continue;
      return(shift);
   }
   return(-1);
}

//--------------------------------------------------------------------------------------------------------+
//ローソク足の構成要素（ヒゲ）算出処理
//   処理:入力されたローソク足の構成要素を算出する処理
//   引数:通貨ペア,時間足,ローソク足の位置,ローソク足の構成(0:上ヒゲ,1:実体,2:下ヒゲ,3:値幅)
//   戻り値:指定したローソク足の構成から算出したpips
//--------------------------------------------------------------------------------------------------------+
double getCandleStickPips(string symbol, int period, int shift, int hige) 
{
   int digits   = (int)MarketInfo(symbol, MODE_DIGITS);
   double open  = iOpen(symbol,period,shift);
   double close = iClose(symbol,period,shift);
   double high  = iHigh(symbol,period,shift);
   double low   = iLow(symbol,period,shift);
   
   // 陽線の場合
   if (open < close) {
      if (hige == 0) {
         return (NormalizeDouble(PriceToPips(MathAbs(high - close)), digits));
      }
      else if (hige == 1) {
         return (NormalizeDouble(PriceToPips(MathAbs(close - open)), digits));
      }
      else if (hige == 2) {
         return (NormalizeDouble(PriceToPips(MathAbs(open - low)), digits));
      }
      else if (hige == 3) {
         return (NormalizeDouble(PriceToPips(MathAbs(high - low)), digits));
      }
      else {
         return (NormalizeDouble(PriceToPips(MathAbs(high - close)), digits));
      }
   }
   // 陰線の場合
   else {
      if (hige == 0) {
         return (NormalizeDouble(PriceToPips(MathAbs(high - open)), digits));
      }
      else if (hige == 1) {
         return (NormalizeDouble(PriceToPips(MathAbs(open - close)), digits));
      }
      else if (hige == 2) {
         return (NormalizeDouble(PriceToPips(MathAbs(close - low)), digits));
      }
      else if (hige == 3) {
         return (NormalizeDouble(PriceToPips(MathAbs(high - low)), digits));
      }
      else {
         return (NormalizeDouble(PriceToPips(MathAbs(high - open)), digits));
      }
   }
   return 0;
}

//--------------------------------------------------------------------------------------------------------+
//テクニカル指標RCI算出処理
//   処理:RCIを算出する処理
//   引数:通貨ペア,時間足,ローソク足の本数,ローソク足の位置
//   戻り値:RCI
//--------------------------------------------------------------------------------------------------------+
double iRCI(string symbol, int period, int number, int shift)
{
    int rank;
    double d = 0;
    double close_price[];
    ArrayResize(close_price, number); 

    for (int i = 0; i < number; i++) {
        close_price[i] = iClose(symbol, period, i+shift);
    }
    
    ArraySort(close_price, WHOLE_ARRAY, 0, MODE_DESCEND);
    
    for (int i = 0; i < number; i++) {
        rank = ArrayBsearch(close_price,iClose(symbol, period, i+shift),WHOLE_ARRAY,0,MODE_DESCEND);
        d += MathPow(i-rank,2);
    }

    return((1 - 6 * d / (number * (number * number - 1))) * 100);
}

//--------------------------------------------------------------------------------------------------------+
//注文送信時の余剰証拠金確認
//   処理:指定した引数でエントリーした場合の、余剰証拠金を確認する
//   引数:売買種別,ロット数,価格
//   戻り値:処理結果(true:問題なし, false:余剰証拠金不足)
//--------------------------------------------------------------------------------------------------------+
bool marginCheck(int type, double lots, double price)
{  
   if(AccountFreeMarginCheck(Symbol(),type,lots) <= 0) {
      if(lastAlertTime != Time[0]) {
         Alert("[OrderSend Error] : Not enough money");
         lastAlertTime = Time[0]; 
      }
      return(false);
   }
   return(true);
}


//--------------------------------------------------------------------------------------------------------+
//トレーリングストップ用注文変更関数                                                                     
//   処理:オープンポジションのストップロス、テイクプロフィットの変更注文を送信する。                     
//   引数:間隔,ストップロス、テイクプロフィットを変更するポジションのマジックナンバー                          
//   戻り値:なし                                                       
//--------------------------------------------------------------------------------------------------------+
void TrailingStop(double ts_value, int magic)
{
  double sl = 0;

  for(int i = OrdersTotal() - 1; i >= 0; i--) {
    if(OrderSelect(i, SELECT_BY_POS) == false) continue;
    if(OrderSymbol() != Symbol() || OrderMagicNumber() != magic) continue;

    if(OrderType() == OP_BUY) {
      sl = Bid - PipsToPrice(ts_value);
      if(sl > OrderOpenPrice() && sl > OrderStopLoss()) {
        setTPSL(0, sl, OrderTicket());
      }
    }
    else if(OrderType() == OP_SELL) {
      sl = Ask + PipsToPrice(ts_value);
      if(sl < OrderOpenPrice() && (sl < OrderStopLoss() || OrderStopLoss() == 0)) {
        setTPSL(0, sl, OrderTicket());
      }
    }
  }
}

//--------------------------------------------------------------------------------------------------------+
//スプレッドでエントリーを制限する。
//   処理:エントリー時のスプレッドが、 引数で設定した値（単位はpips）以下の場合のみエントリーする。
//   引数:売買シグナル(買い:正の整数, 売り:負の整数),最大スプレッド
//   戻り値:売買シグナル、引数で設定した値（単位はpips）以上なら0
//--------------------------------------------------------------------------------------------------------+
int checkSpread(int signal, double value)
{
   if(PointToPrice((int)MarketInfo(Symbol(), MODE_SPREAD)) > PipsToPrice(value)) return(0);
   return(signal);
}

//--------------------------------------------------------------------------------------------------------+
//最大ポジション数制限確認                                                                                
//   処理:保有中ポジション数を算出して最大値を超えていないかをチェックする。                              
//   引数:最大ポジション数,マジックナンバー(配列),売買シグナル(買い:正の整数, 売り:負の整数)                                                                       
//   戻り値:最大ポジション数未満なら売買シグナル、最大ポジション数以上なら0                                  
//--------------------------------------------------------------------------------------------------------+
int PositionFilter(int max, int &magic[], int signal)
{
  int count = 0;
  int total = ArraySize(magic);

  for(int i = OrdersTotal() - 1; i >= 0; i--) {
    if(OrderSelect(i, SELECT_BY_POS) == false) continue;
    if(OrderSymbol() != Symbol()) continue;

    for(int j = 0; j < total; j++) {
      if(magic[j] == OrderMagicNumber()) {
        count++;
      }
    }
  }

  if((count < max) == false) signal = 0;

  return signal;
}

